/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.service.AreaService;
import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.ChannelService;
import com.bxm.localnews.base.vo.BizLogParamBuilder;
import com.bxm.localnews.common.vo.Channel;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizLogServiceImpl
implements BizLogService {
    private BizLogAsyncSaveService bizLogAsyncSaveService;
    private ChannelService channelService;
    private AreaService areaService;

    @Autowired
    public BizLogServiceImpl(BizLogAsyncSaveService bizLogAsyncSaveService, ChannelService channelService, AreaService areaService) {
        this.bizLogAsyncSaveService = bizLogAsyncSaveService;
        this.channelService = channelService;
        this.areaService = areaService;
    }

    private BizLogParamBuilder build(String event) {
        return BizLogParamBuilder.build(event, this.bizLogAsyncSaveService);
    }

    public void newUser(Long userId, String channel) {
        BizLogParamBuilder builder = this.build("1002").setUid(userId);
        Channel channelCode = this.channelService.getChannelByCode(channel);
        if (channelCode.getId() != null) {
            builder.setSrc(channelCode.getId());
        } else {
            builder.setSrc(5L);
        }
        builder.save();
    }

    public void login(Long userId) {
        this.build("1003").setUid(userId).save();
    }

    public void changeGender(Long userId, int sex) {
        this.build("1004").setUid(userId).setEventVal(sex).save();
    }

    public void changeArea(Long userId, String areaCode) {
        BizLogParamBuilder builder = this.build("1005").setUid(userId);
        if (StringUtils.isNotBlank((CharSequence)areaCode)) {
            builder.setEventVal(this.areaService.getBizLogArea(areaCode));
        }
        builder.setUid(userId).save();
    }

    public void inviteSuccessed(Long userId, Long invitedUserId) {
        this.build("2006").setUid(userId).setEventVal(invitedUserId).save();
    }

    public void joinPrivilege(Long userId, Long privilegeId) {
        this.build("3006").setUid(userId).setActivityId(privilegeId).save();
    }

    public void invitePrivilege(Long userId, Long invitedUserId, Long privilegeId) {
        this.build("3009").setUid(userId).setEventVal(invitedUserId).setActivityId(privilegeId).save();
    }
}

