/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.AreaCodeMapper;
import com.bxm.localnews.base.domain.AreaDivisionMapper;
import com.bxm.localnews.base.domain.LocationMapper;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.LocationDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.vo.AreaCode;
import com.bxm.localnews.common.vo.AreaDivision;
import com.bxm.localnews.common.vo.Location;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationServiceImpl
extends BaseService
implements LocationService,
LocationFacadeService {
    private static final int AREA_CODE_LENGTH = 12;
    private final AreaCodeMapper areaCodeMapper;
    @Autowired
    private AreaDivisionMapper areaDivisionMapper;
    @Autowired
    private LocationMapper locationMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public LocationServiceImpl(AreaCodeMapper areaCodeMapper) {
        this.areaCodeMapper = areaCodeMapper;
    }

    @Override
    public AreaCode selectByAreaName(String name, String province) {
        List areaCodeList = this.areaCodeMapper.selectByAreaName(province);
        if (areaCodeList != null) {
            for (AreaCode areaCode : areaCodeList) {
                String codeSplit;
                List areaList;
                String tail = areaCode.getAreaCode().substring(2, 6);
                if (!"0000".equalsIgnoreCase(tail) || (areaList = this.areaCodeMapper.selectByAreaCode(name, codeSplit = areaCode.getAreaCode().substring(0, 2))) == null) continue;
                return (AreaCode)areaList.get(0);
            }
        }
        return null;
    }

    @Override
    public LocationMeta listLocation() {
        TypeReference<List<LocationDTO>> openedCityTypeReference;
        KeyGenerator openedCityKey;
        List<LocationDTO> openedLocationList;
        KeyGenerator hotCityKey = RedisConfig.HOT_LOCATION;
        TypeReference<List<LocationDTO>> hotCityTypeReference = new TypeReference<List<LocationDTO>>(){};
        List<LocationDTO> hotLocationList = (List<LocationDTO>)this.redisStringAdapter.get(hotCityKey, (TypeReference)hotCityTypeReference);
        if (hotLocationList == null) {
            hotLocationList = this.listHotLocation();
            this.redisStringAdapter.set(hotCityKey, hotLocationList);
        }
        if ((openedLocationList = (List<LocationDTO>)this.redisStringAdapter.get(openedCityKey = RedisConfig.OPENED_LOCATION, (TypeReference)(openedCityTypeReference = new TypeReference<List<LocationDTO>>(){}))) == null) {
            openedLocationList = this.listOpenedLocation();
            this.redisStringAdapter.set(openedCityKey, openedLocationList);
        }
        LocationMeta locationMeta = new LocationMeta();
        locationMeta.setHotLocation(hotLocationList);
        locationMeta.setOpenedLocation(openedLocationList);
        return locationMeta;
    }

    @Override
    public List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode) {
        AreaDivision areaDivisionParam = new AreaDivision();
        areaDivisionParam.setParentCode(parentCode);
        List areaDivisionList = this.areaDivisionMapper.selectByModel(areaDivisionParam);
        return areaDivisionList.stream().map(this::convertDivision).collect(Collectors.toList());
    }

    private AreaDivisionDTO convertDivision(AreaDivision areaDivision) {
        AreaDivisionDTO areaDivisionDTO = new AreaDivisionDTO();
        areaDivisionDTO.setCode(areaDivision.getCode());
        areaDivisionDTO.setLevel(areaDivision.getLevel());
        areaDivisionDTO.setName(areaDivision.getName());
        return areaDivisionDTO;
    }

    private List<LocationDTO> listHotLocation() {
        Location locationParam = new Location();
        locationParam.setHot(Byte.valueOf((byte)1));
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        return locationDTOList;
    }

    private List<LocationDTO> listOpenedLocation() {
        Location locationParam = new Location();
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        locationDTOList.forEach(x -> x.setPinyin(x.getPinyin().substring(0, 1).toUpperCase()));
        return locationDTOList;
    }

    private LocationDTO convertLocation(Location location) {
        LocationDTO locationDTO = new LocationDTO();
        locationDTO.setCode(location.getCode());
        locationDTO.setHot(location.getHot());
        locationDTO.setLevel(location.getLevel());
        locationDTO.setName(location.getName());
        locationDTO.setPinyin(location.getPinyin().substring(0, 1).toUpperCase());
        return locationDTO;
    }

    public com.bxm.localnews.base.dto.LocationDTO getLocationByCode(String code) {
        com.bxm.localnews.base.dto.LocationDTO locationDTO = null;
        Location location = this.locationMapper.selectByCode(code);
        if (null != location) {
            locationDTO = new com.bxm.localnews.base.dto.LocationDTO();
            BeanUtils.copyProperties((Object)location, (Object)locationDTO);
        }
        return locationDTO;
    }

    public boolean compareLocationCode(String originalCode, List<String> standardCodeList) {
        this.logger.debug("\u53c2\u52a0\u6d3b\u52a8\u5730\u533a\u7f16\u7801\u76f8\u6bd4\u8f83\uff0c\u7528\u6237\u5730\u533a\u7f16\u53f7\uff1a{} \uff0c\u6d3b\u52a8\u5730\u533a\u5217\u8868\uff1a{}", (Object)originalCode, standardCodeList);
        if (null != originalCode && CollectionUtils.isNotEmpty(standardCodeList)) {
            com.bxm.localnews.base.dto.LocationDTO locationDTO;
            String fullCode = originalCode;
            if (12 != fullCode.length() && null == (locationDTO = this.getLocationByCode(fullCode = originalCode + "000000"))) {
                fullCode = originalCode.substring(0, 4) + "00000000";
            }
            if (standardCodeList.contains(fullCode)) {
                return true;
            }
        }
        return false;
    }
}

