/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.PrivilegeShareShortLinkDTO;
import com.bxm.localnews.common.vo.ShortLinkReq;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service(value="shortLinkService")
@RefreshScope
public class ShortLinkServiceImpl
implements ShortLinkService {
    private static final String SHORT = "t";
    private RedisStringAdapter redisStringAdapter;
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public ShortLinkServiceImpl(BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter) {
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    public String getRegisterShortUrl(ShortLinkReq req) {
        StringBuilder url = new StringBuilder();
        String channelUrl = this.bizConfigProperties.getChannelUrl();
        url.append(channelUrl).append(req.getUserId());
        return this.getShortUrl(url.toString(), true);
    }

    public String getDownloadShortUrl() {
        return this.getShortUrl(this.bizConfigProperties.getDownloadUrl(), true);
    }

    public String getFriendSweepShortUrl(ShortLinkReq req) {
        StringBuilder url = new StringBuilder();
        String channelUrl = this.bizConfigProperties.getFriendSweepUrl();
        url.append(channelUrl).append(req.getUserId());
        return this.getShortUrl(url.toString(), true);
    }

    public String getMachineShortLink(String machineId) {
        String shortCode = ShortUrlGenerator.getShortUrl((String)machineId)[0];
        KeyGenerator shortKey = RedisConfig.MACHINE_SHORT_URL_KEY.copy().setKey(shortCode);
        this.redisStringAdapter.set(shortKey, (Object)machineId);
        StringBuilder sortUrl = new StringBuilder();
        String host = this.bizConfigProperties.getServerHost();
        sortUrl.append(host).append("/").append("m").append("/");
        sortUrl.append(shortCode);
        return sortUrl.toString();
    }

    public String getPrivilegeShareShortLink(PrivilegeShareShortLinkDTO privilegeShareShortLinkDTO) {
        String url = null;
        try {
            url = this.bizConfigProperties.getPrivilegeShareUrl() + "?" + URLEncoder.encode(privilegeShareShortLinkDTO.toString(), "UTF-8") + "&response_type=code&scope=snsapi_userinfo#wechat_redirect";
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return this.getShortUrl(url, true);
    }

    private String getShortUrl(String url, boolean expired) {
        StringBuilder sortUrl = new StringBuilder();
        String host = this.bizConfigProperties.getServerHost();
        sortUrl.append(host).append("/").append(SHORT).append("/");
        String key = ShortUrlGenerator.getShortUrl((String)url)[0];
        sortUrl.append(key);
        if (expired) {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url, 7776000L);
        } else {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url);
        }
        return sortUrl.toString();
    }
}

