/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.vo;

import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.google.common.collect.Maps;
import java.util.Map;

public class BizLogParamBuilder {
    private Map<String, String> result = Maps.newHashMap();
    private BizLogAsyncSaveService bizLogAsyncSaveService;

    private BizLogParamBuilder() {
    }

    public static BizLogParamBuilder build(String event, BizLogAsyncSaveService bizLogAsyncSaveService) {
        BizLogParamBuilder builder = new BizLogParamBuilder();
        builder.get().put("e", event);
        builder.get().put("p", "news");
        builder.get().put("v", "1.1.0");
        builder.get().put("dtype", "3");
        builder.get().put("ts", System.currentTimeMillis() + "");
        builder.setBizLogAsyncSaveService(bizLogAsyncSaveService);
        return builder;
    }

    public BizLogParamBuilder setUid(Long userId) {
        this.result.put("uid", this.convert(userId));
        return this;
    }

    public BizLogParamBuilder setActivityId(Long privilegeId) {
        this.result.put("activityid", this.convert(privilegeId));
        return this;
    }

    public BizLogParamBuilder setEventVal(Object val) {
        this.result.put("ev", this.convert(val));
        return this;
    }

    public BizLogParamBuilder setSrc(Long channel) {
        this.result.put("src", this.convert(channel));
        return this;
    }

    private void setBizLogAsyncSaveService(BizLogAsyncSaveService bizLogAsyncSaveService) {
        this.bizLogAsyncSaveService = bizLogAsyncSaveService;
    }

    private String convert(Object obj) {
        if (null == obj) {
            return "";
        }
        return obj.toString();
    }

    private Map<String, String> get() {
        return this.result;
    }

    public void save() {
        this.bizLogAsyncSaveService.save(this.result);
    }
}

