package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.LocationDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.vo.AreaCode;
import com.bxm.localnews.common.vo.Location;

import java.util.List;
import java.util.Map;

public interface LocationService {

    /**
     * 用途：获取对应地区的编码
     * @param name 地区
     * @param province 省市
     * @return 地区的编码
     */
    AreaCode selectByAreaName(String name, String province);

    /**
     * 用途：获取热门城市列表以及已开通城市列表
     * @return
     */
    LocationMeta listLocation();

    /**
     * 用途：根据父级编号获得省市区街道地址
     * @param parentCode
     * @return
     */
    List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode);


}
