package com.bxm.localnews.base.service.impl;

import java.util.List;
import java.util.Optional;

import com.bxm.localnews.base.constant.PublishStateEnum;
import com.bxm.localnews.base.domain.AppVersionMapper;
import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.util.IPUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.IP;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Administrator on 2018/2/22 0022.
 */
@Service
@Transactional(rollbackFor = Exception.class)
@RefreshScope
public class AppVersionServiceImpl implements AppVersionService {

    private AppVersionMapper appVersionMapper;

    private BizConfigProperties bizConfigProperties;

    private RedisStringAdapter redisStringAdapter;

    private RedisHashMapAdapter redisHashMapAdapter;

    private IPUtil ipUtil;

    @Autowired
    public AppVersionServiceImpl(AppVersionMapper appVersionMapper, BizConfigProperties bizConfigProperties,
                                 RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter,
                                 IPUtil ipUtil) {
        this.appVersionMapper = appVersionMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.ipUtil = ipUtil;
    }

    /**
     * 判断是否是美国的ip
     *
     * @param ip
     * @return
     */
    private Boolean isAbroadOfCountry(String ip) {
        Boolean isAbroadCountry = redisHashMapAdapter.get(getCountryKey(), ip, Boolean.class);
        if (isAbroadCountry == null) {
            isAbroadCountry = Boolean.FALSE;

            IP i = ipUtil.find(ip);
            if (i == null || i.getCountry() == null) {
                isAbroadCountry = Boolean.TRUE;
            }
            if (i != null && "美国".equals(i.getCountry())) {
                isAbroadCountry = Boolean.TRUE;
                redisHashMapAdapter.put(getCountryKey(), ip, Boolean.TRUE);
            }
        }

        return isAbroadCountry;
    }

    private KeyGenerator getCountryKey() {
        return RedisConfig.BASE_IP.copy().appendKey("list");
    }


    @Override
    public boolean inWhiteList(String phone) {
        return bizConfigProperties.getWhiteList().contains(phone);
    }

    @Override
    public AppVersionDTO getAppVersion(BasicParam basicParam) {
        AppVersionDTO appVersionDTO = new AppVersionDTO();
        List<AppVersionDTO> appVersionDTOS = getAllAppVersion();
        //获取对应渠道最新的版本信息
        if (CollectionUtils.isNotEmpty(appVersionDTOS)) {
            for (int i = appVersionDTOS.size() - 1; i >= 0; i--) {
                AppVersionDTO app = appVersionDTOS.get(i);
                if (app.getMobileType().equals(basicParam.getPlatform()) && app.getCode().equals(basicParam.getChnl())) {
                    appVersionDTO = app;
                    break;
                }
            }
        }

        Optional<AppVersionDTO> optional = appVersionDTOS.stream().filter(app ->
                app.getVersion().equals(basicParam.getCurVer()) && app.getCode().equals(basicParam.getChnl())
        ).findFirst();

        if (optional.isPresent()) {
            appVersionDTO.setIsForce(optional.get().getIsForce());
            appVersionDTO.setStatus(optional.get().getStatus());
        }

        return appVersionDTO;
    }

    @Override
    public AppVersionDTO getAppVersion(BasicParam basicParam, String ip) {
        AppVersionDTO appVersionDTO = getAppVersion(basicParam);

        if (AppConst.PLATFORM.IOS == basicParam.getPlatform()
                && PublishStateEnum.NORMAL.getState().equals(appVersionDTO.getStatus())
                && isAbroadOfCountry(ip)) {
            appVersionDTO.setStatus(PublishStateEnum.PURSE.getState());
        }

        return appVersionDTO;
    }

    /**
     * 获取所有渠道的版本信息
     *
     * @return
     */
    private List<AppVersionDTO> getAllAppVersion() {
        TypeReference<List<AppVersionDTO>> typeReference = new TypeReference<List<AppVersionDTO>>() {
        };
        List<AppVersionDTO> appVersionDTOS = redisStringAdapter.get(this.getAppChannelListKey(), typeReference);

        if (CollectionUtils.isEmpty(appVersionDTOS)) {
            appVersionDTOS = this.appVersionMapper.getAllAppVersion();
            redisStringAdapter.set(this.getAppChannelListKey(), appVersionDTOS);
        }

        return appVersionDTOS;
    }

    /**
     * 获取渠道版本列表的key
     *
     * @return
     */
    private KeyGenerator getAppChannelListKey() {
        return RedisConfig.BASE_APPVERSION_CHANNEL.copy().appendKey("list");
    }
}
