package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.AreaInfoMapper;
import com.bxm.localnews.base.service.AreaInfoService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class AreaInfoServiceImpl extends BaseService implements AreaInfoService {

    private final AreaInfoMapper areaInfoMapper;

    private final RedisStringAdapter redisStringAdapter;

    @Autowired
    public AreaInfoServiceImpl(AreaInfoMapper areaInfoMapper, RedisStringAdapter redisStringAdapter) {
        this.areaInfoMapper = areaInfoMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public AreaInfo getAreaInfo(String code) {

        KeyGenerator areaInfoKey = RedisConfig.AREA_INFO;
        TypeReference<List<AreaInfo>> areaInfoTypeReference = new TypeReference<List<AreaInfo>>() {
        };
        AreaInfo areaInfo = null;
        List<AreaInfo> areaInfoList = redisStringAdapter.get(areaInfoKey, areaInfoTypeReference);
        if (areaInfoList != null) {
            Optional<AreaInfo> areaInfoOptional = areaInfoList.stream().filter(x -> x.getCode().equals(code)).findFirst();
            if (areaInfoOptional.isPresent()) {
                areaInfo = areaInfoOptional.get();
            }
        }

        if (null == areaInfo) {
            areaInfoList = areaInfoMapper.selectByModel(null);
            redisStringAdapter.set(areaInfoKey, areaInfoList);
            areaInfo = areaInfoMapper.selectByCode(code);
        }

        return areaInfo;
    }

}
