package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.PrivilegeShareShortLinkDTO;
import com.bxm.localnews.common.vo.ShortLinkReq;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import static com.bxm.localnews.common.constant.RedisConfig.SHORT_URL;

/**
 * Created by Administrator on 2018/4/3.
 */
@Service("shortLinkService")
@RefreshScope
public class ShortLinkServiceImpl implements ShortLinkService {

    /**
     * 短链接host
     */
    private final static String SHORT = "t";

    private RedisStringAdapter redisStringAdapter;

    private BizConfigProperties bizConfigProperties;

    @Autowired
    public ShortLinkServiceImpl(BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter) {
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public String getRegisterShortUrl(ShortLinkReq req) {
        StringBuilder url = new StringBuilder();
        //渠道地址
        String channelUrl = bizConfigProperties.getChannelUrl();
        //邀请注册地址
        url.append(channelUrl).append(req.getUserId());
        return this.getShortUrl(url.toString(), true);
    }

    @Override
    public String getDownloadShortUrl() {
        return getShortUrl(bizConfigProperties.getDownloadUrl(), true);
    }

    @Override
    public String getFriendSweepShortUrl(ShortLinkReq req) {
        StringBuilder url = new StringBuilder();
        //渠道地址
        String channelUrl = bizConfigProperties.getFriendSweepUrl();
        url.append(channelUrl).append(req.getUserId());
        return this.getShortUrl(url.toString(), true);
    }

    @Override
    public String getMachineShortLink(String machineId) {
        String shortCode = ShortUrlGenerator.getShortUrl(machineId)[0];
        KeyGenerator shortKey = RedisConfig.MACHINE_SHORT_URL_KEY.copy().setKey(shortCode);
        redisStringAdapter.set(shortKey, machineId);

        StringBuilder sortUrl = new StringBuilder();
        String host = bizConfigProperties.getServerHost();
        sortUrl.append(host).append("/").append("m").append("/");
        sortUrl.append(shortCode);

        return sortUrl.toString();
    }

    @Override
    public String getPrivilegeShareShortLink(PrivilegeShareShortLinkDTO privilegeShareShortLinkDTO) {
        String url = null;
        try {
            url = bizConfigProperties.getPrivilegeShareUrl() + "?" + URLEncoder.encode(
                    privilegeShareShortLinkDTO.toString(), "UTF-8") + "&response_type=code&scope=snsapi_userinfo#wechat_redirect";
        } catch (UnsupportedEncodingException e) {
            return null;
        }

        return getShortUrl(url, true);
    }

    private String getShortUrl(String url, boolean expired) {
        //短连接地址
        StringBuilder sortUrl = new StringBuilder();
        String host = bizConfigProperties.getServerHost();
        sortUrl.append(host).append("/").append(SHORT).append("/");
        String key = ShortUrlGenerator.getShortUrl(url)[0];
        sortUrl.append(key);
        //缓存180天，超时，则跳转到注册界面
        if (expired) {
            this.redisStringAdapter.set(SHORT_URL.copy().appendKey(key), url, 3600 * 24 * 90);
        } else {
            this.redisStringAdapter.set(SHORT_URL.copy().appendKey(key), url);
        }
        return sortUrl.toString();
    }

}
