/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.constant.PublishStateEnum;
import com.bxm.localnews.base.constant.VersionForceEnum;
import com.bxm.localnews.base.domain.AppVersionMapper;
import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.util.IPUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.IP;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AppVersionServiceImpl
extends BaseService
implements AppVersionService {
    private AppVersionMapper appVersionMapper;
    private BizConfigProperties bizConfigProperties;
    private RedisStringAdapter redisStringAdapter;
    private RedisHashMapAdapter redisHashMapAdapter;
    private IPUtil ipUtil;

    @Autowired
    public AppVersionServiceImpl(AppVersionMapper appVersionMapper, BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, IPUtil ipUtil) {
        this.appVersionMapper = appVersionMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.ipUtil = ipUtil;
    }

    private Boolean isAbroadOfCountry(String ip) {
        Boolean isAbroadCountry = (Boolean)this.redisHashMapAdapter.get(this.getCountryKey(), ip, Boolean.class);
        if (isAbroadCountry == null) {
            isAbroadCountry = Boolean.FALSE;
            IP i = this.ipUtil.find(ip);
            if (i == null || i.getCountry() == null) {
                isAbroadCountry = Boolean.TRUE;
            }
            if (i != null && "\u7f8e\u56fd".equals(i.getCountry())) {
                isAbroadCountry = Boolean.TRUE;
                this.redisHashMapAdapter.put(this.getCountryKey(), ip, (Object)Boolean.TRUE);
            }
        }
        return isAbroadCountry;
    }

    private KeyGenerator getCountryKey() {
        return RedisConfig.BASE_IP.copy().appendKey((Object)"list");
    }

    @Override
    public boolean inWhiteList(String phone) {
        return this.bizConfigProperties.getWhiteList().contains(phone);
    }

    @Override
    public AppVersionDTO getAppVersion(BasicParam basicParam) {
        AppVersionDTO appVersionDTO = new AppVersionDTO();
        appVersionDTO.setMobileType(Integer.valueOf(basicParam.getPlatform()));
        appVersionDTO.setCode(basicParam.getChnl());
        List<AppVersionDTO> appVersionDTOS = this.getAllAppVersion();
        List<AppVersionDTO> filterAppVersionDTOs = appVersionDTOS.stream().filter(app -> app.getMobileType().equals(basicParam.getPlatform()) && app.getCode().equals(basicParam.getChnl())).collect(Collectors.toList());
        String curVer = basicParam.getCurVer();
        if (basicParam.getPlatform() == 2) {
            String string = curVer = this.isHighVersion(basicParam.getVersion(), "1.2.0") == 1 ? basicParam.getCurVer() : basicParam.getVersion();
        }
        if (CollectionUtils.isEmpty(filterAppVersionDTOs)) {
            appVersionDTO.setVersion(curVer);
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
            return appVersionDTO;
        }
        appVersionDTO = this.matchAllVersion(filterAppVersionDTOs);
        if (this.isHighVersion(curVer, appVersionDTO.getVersion()) != -1) {
            appVersionDTO.setVersion(curVer);
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
            return appVersionDTO;
        }
        List<AppVersionDTO> enableAppVersionDTOS = filterAppVersionDTOs.stream().filter(app -> app.getEnable() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enableAppVersionDTOS)) {
            appVersionDTO.setVersion(curVer);
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
            return appVersionDTO;
        }
        appVersionDTO = this.matchAllVersion(enableAppVersionDTOS);
        if (this.isHighVersion(curVer, appVersionDTO.getVersion()) != -1) {
            appVersionDTO.setVersion(curVer);
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
            return appVersionDTO;
        }
        if (VersionForceEnum.FORCE_UPDATE.getState().equals(appVersionDTO.getIsForce())) {
            if (this.isHighVersion(curVer, appVersionDTO.getForceVersion()) == 1) {
                appVersionDTO.setIsForce(VersionForceEnum.REMING_UPDATE.getState());
            } else {
                appVersionDTO.setIsForce(VersionForceEnum.FORCE_UPDATE.getState());
            }
        }
        AppVersionDTO curVersion = null;
        for (AppVersionDTO app2 : appVersionDTOS) {
            if (!app2.getVersion().equals(curVer) || !app2.getCode().equals(basicParam.getChnl())) continue;
            curVersion = app2;
        }
        if (curVersion == null) {
            return appVersionDTO;
        }
        if (appVersionDTO.getVersion().equals(curVersion.getVersion())) {
            appVersionDTO.setVersion(curVer);
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
        }
        appVersionDTO.setStatus(curVersion.getStatus());
        return appVersionDTO;
    }

    private AppVersionDTO matchAllVersion(List<AppVersionDTO> appVersionDTOS) {
        AppVersionDTO appVersionDTO = appVersionDTOS.get(appVersionDTOS.size() - 1);
        if (appVersionDTOS.size() >= 2) {
            for (int i = appVersionDTOS.size() - 2; i >= 0; --i) {
                if (this.isHighVersion(appVersionDTOS.get(i).getVersion(), appVersionDTO.getVersion()) != 1) continue;
                appVersionDTO = appVersionDTOS.get(i);
            }
        }
        return appVersionDTO;
    }

    private AppVersionDTO queryAppVersion(List<AppVersionDTO> appVersionDTOS, AppVersionDTO appVersionDTO) {
        Optional<AppVersionDTO> optional = appVersionDTOS.stream().filter(app -> app.getVersion().equals(appVersionDTO.getForceVersion())).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    @Override
    public AppVersionDTO getAppVersion(BasicParam basicParam, String ip) {
        AppVersionDTO appVersionDTO = this.getAppVersion(basicParam);
        if (3 == basicParam.getPlatform()) {
            appVersionDTO.setStatus(PublishStateEnum.NORMAL.getState());
            return appVersionDTO;
        }
        if (2 == basicParam.getPlatform() && PublishStateEnum.NORMAL.getState().equals(appVersionDTO.getStatus()) && this.isAbroadOfCountry(ip).booleanValue()) {
            appVersionDTO.setStatus(PublishStateEnum.PURSE.getState());
        }
        return appVersionDTO;
    }

    private List<AppVersionDTO> getAllAppVersion() {
        TypeReference<List<AppVersionDTO>> typeReference = new TypeReference<List<AppVersionDTO>>(){};
        List appVersionDTOS = (List)this.redisStringAdapter.get(this.getAppChannelListKey(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)appVersionDTOS)) {
            appVersionDTOS = this.appVersionMapper.getAllAppVersion();
            this.redisStringAdapter.set(this.getAppChannelListKey(), (Object)appVersionDTOS);
        }
        return appVersionDTOS;
    }

    private KeyGenerator getAppChannelListKey() {
        return RedisConfig.BASE_APPVERSION_CHANNEL.copy().appendKey((Object)"list");
    }

    @Override
    public int isHighVersion(String curVersion, String version) {
        if (curVersion == null && version != null) {
            return -1;
        }
        if (curVersion != null && version == null) {
            return 1;
        }
        if (StringUtils.equals((CharSequence)curVersion, (CharSequence)version)) {
            return 0;
        }
        return StringUtils.compareVersion((String)curVersion, (String)version);
    }
}

