/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.base.domain.BuryPointMapper;
import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.vo.BuryPoint;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.gexin.fastjson.JSON;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class BizLogAsyncSaveServiceImpl
extends BaseService
implements BizLogAsyncSaveService {
    private HttpClientService httpClientService;
    private BizConfigProperties bizConfigProperties;
    private BuryPointMapper buryPointMapper;
    private SequenceCreater sequenceCreater;

    @Autowired
    public BizLogAsyncSaveServiceImpl(HttpClientService httpClientService, BizConfigProperties bizConfigProperties, BuryPointMapper buryPointMapper, SequenceCreater sequenceCreater) {
        this.httpClientService = httpClientService;
        this.bizConfigProperties = bizConfigProperties;
        this.buryPointMapper = buryPointMapper;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    @Async
    public void save(Map<String, String> data) {
        try {
            this.httpClientService.doGet(this.bizConfigProperties.getBizLogUrl(), data);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveDB(Map<String, String> data) {
        BuryPoint buryPoint = new BuryPoint();
        buryPoint.setId(this.sequenceCreater.nextLongId());
        buryPoint.setE(data.get("e"));
        buryPoint.setV(data.get("v"));
        buryPoint.setDtype(data.get("dtype"));
        buryPoint.setTs(data.get("ts"));
        buryPoint.setIp(data.get("ip"));
        buryPoint.setA(data.get("a"));
        buryPoint.setData(JSON.toJSONString(data));
        this.buryPointMapper.insertSelective(buryPoint);
    }
}

