/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.LocationRelationMapper;
import com.bxm.localnews.base.service.LocationRelationService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationRelationDTO;
import com.bxm.localnews.common.vo.LocationRelation;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationRelationServiceImpl
extends BaseService
implements LocationRelationService {
    @Autowired
    LocationRelationMapper locationRelationMapper;
    @Autowired
    RedisStringAdapter redisStringAdapter;

    @Override
    public LocationRelationDTO getLocationRelation(String code, Byte type) {
        LocationRelation relation = new LocationRelation();
        relation.setLocationCode(code);
        relation.setType(this.generateType(type));
        List locationRelationList = this.locationRelationMapper.selectByModel(relation);
        if (CollectionUtils.isNotEmpty((Collection)locationRelationList)) {
            LocationRelation locationRelation = locationRelationList.stream().min(Comparator.comparing(LocationRelation::getShareTime)).get();
            locationRelation.setShareTime(Integer.valueOf(locationRelation.getShareTime() + 1));
            this.locationRelationMapper.updateByPrimaryKey(locationRelation);
            return this.convertLocationRelation(locationRelation);
        }
        return new LocationRelationDTO();
    }

    private Byte generateType(Byte type) {
        if (type == 5) {
            return (byte)6;
        }
        if (type == 6) {
            return (byte)8;
        }
        if (type == 9 || type == 10) {
            return type;
        }
        Long increValue = 0L;
        if (type == 1) {
            increValue = this.redisStringAdapter.increment(this.getWxTypeKey());
        }
        if (type == 2) {
            increValue = this.redisStringAdapter.increment(this.getWxFriendKey());
        }
        if (increValue % 2L == 1L) {
            type = (byte)(type + 2);
        }
        return type;
    }

    private LocationRelationDTO convertLocationRelation(LocationRelation locationRelation) {
        LocationRelationDTO locationRelationDTO = new LocationRelationDTO();
        locationRelationDTO.setContent(locationRelation.getContent());
        locationRelationDTO.setId(locationRelation.getId());
        locationRelationDTO.setLocationCode(locationRelation.getLocationCode());
        locationRelationDTO.setType(locationRelation.getType());
        locationRelationDTO.setImgUrl(locationRelation.getImgUrl());
        return locationRelationDTO;
    }

    private KeyGenerator getFixedShareCode() {
        return RedisConfig.WEIXIN_SHARE_FIXED_AREACODE.copy();
    }

    private KeyGenerator getWxTypeKey() {
        return RedisConfig.WEIXIN_LOCATION_RELATION.copy();
    }

    private KeyGenerator getWxFriendKey() {
        return RedisConfig.WEIXIN_FRIEND_LOCATION_RELATION.copy();
    }

    private KeyGenerator getWxAppletTypeKey() {
        return RedisConfig.WEIXIN_APPLET_LOCATION_RELATION.copy();
    }

    private KeyGenerator getWxAppletFriendKey() {
        return RedisConfig.WEIXIN_APPLET_FRIEND_LOCATION_RELATION.copy();
    }
}

