package com.bxm.localnews.base.service;

import com.bxm.localnews.common.param.GetAreaInfoParam;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.localnews.common.vo.BasicParam;

public interface AreaInfoService {

    /**
     * 根据城市编码获取城市信息
     * 查询不到会查询上级，再查询不到会返回默认城市信息
     * @see #getAreaInfo(GetAreaInfoParam, boolean, boolean);
     * @param code 城市编码
     * @param basicParam 基础参数
     * @return
     */
    AreaInfo getAreaInfo(String code, BasicParam basicParam);

    /**
     * 根据城市编码获取城市信息
     * 如果是3.3.1版本之后，在用户登录后，设置基本信息的地方，根据定位获取到的code到后端获取城市信息获取不到的情况下不查询上一级，也不返回默认城市信息
     * @param param 请求参数
     * @param defaultInfo 是否返回默认信息 true: 根据code肯定会有一个默认城市返回 false: 查询不到就返回空信息
     * @param lastCodeQuery 是否使用code查询最新编码 客户端带过来的code为最新行政编码所以需要设置为true
     * @return
     */
    AreaInfo getAreaInfo(GetAreaInfoParam param, boolean defaultInfo, boolean lastCodeQuery);
}
