package com.bxm.localnews.base.service;

import com.bxm.localnews.common.param.DomainInfoParam;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;

import java.util.List;
import java.util.Map;

/**
 * @author zhaoyadong 2019/1/24 17:59
 * @desc
 */
public interface ClientConfigService {

    /**
     * 获取
     *
     * @return
     */
    Integer getJumpUrlType();

    /**
     * 根据key获取
     *
     * @param key
     * @return
     */
    String getValueByKey(String key);

    /**
     * 获取商家入驻时选择的类别
     */
    List<String> listMerchantCategory();

    /**
     * 获取客户端所有的配置信息
     *
     * @return
     */
    Map<String, String> getAllConfig(Integer platform);

    /**
     * 根据场景值获取可用的h5分享base url
     * @param param 包含场景类型参数的请求参数
     * @return h5分享base url
     */
    String getBaseH5UrlByScene(DomainInfoParam param);
}
