package com.bxm.localnews.base.service.impl;

import java.util.*;

import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.config.ClientConfigProperties;
import com.bxm.localnews.base.service.ClientConfigService;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.param.DomainInfoParam;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.vo.AvailableDomainInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author zhaoyadong 2019/1/24 18:01
 * @desc
 */
@Service

public class ClientConfigServiceImpl implements ClientConfigService {

    @Autowired
    private ClientConfigProperties clientConfigProperties;

    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Autowired
    private DomainService domainService;

    @Override
    public Integer getJumpUrlType() {
        return clientConfigProperties.getJumpUrlType();
    }

    @Override
    public String getValueByKey(String key) {
        return clientConfigProperties.getKeys().get(key);
    }

    @Override
    public List<String> listMerchantCategory() {
        return clientConfigProperties.getMerchantCategory();
    }

    @Override
    public Map<String, String> getAllConfig(Integer platform) {
        Map<String, String> commonMap;
        commonMap = clientConfigProperties.getCommonKeys();

        Map<String, String> specialMap;
        if (platform == 1) {
            specialMap = clientConfigProperties.getAndroidKeys();
        } else if (platform == 2) {
            specialMap = clientConfigProperties.getIosKeys();
        } else if (platform == 3) {
            specialMap = clientConfigProperties.getWebKeys();
        } else if (platform == 5) {
            specialMap = clientConfigProperties.getAppletKeys();
        } else {
            specialMap = clientConfigProperties.getKeys();
        }
        Map<String, String> resultMap = new HashMap<>(commonMap);
        resultMap.putAll(specialMap);

        // 站内的H5 base url
        DomainInfoParam param = new DomainInfoParam();
        param.setScene(Objects.toString(DomainScene.INNER_H5));
        String baseH5UrlByScene = getBaseH5UrlByScene(param);
        if (isNotBlank(baseH5UrlByScene)) {
            // 替换原有的h5Server
            resultMap.put("h5Server", baseH5UrlByScene);
        }
        return resultMap;
    }

    @Override
    public String getBaseH5UrlByScene(DomainInfoParam param) {
        GetAvailableDomainInfoParam infoParam = new GetAvailableDomainInfoParam();
        infoParam.merge(param);
        infoParam.setScene(param.getScene());
        infoParam.setViewScene(param.getViewScene());

        // 老版本的客户端请求如果为空 则表示是客户端请求获取分享url 这里手动指定一下
        if (isBlank(infoParam.getScene())) {
            // 设置域名场景
            infoParam.setScene(Objects.toString(DomainScene.OUTSIDE_SHARE));
            // 设置落地页场景 这里默认指定为内容
            infoParam.setViewScene(Objects.toString(DomainScene.DomainViewScene.CONTENT_VIEW));
        }

        Optional<AvailableDomainInfo> infoOptional = domainService.getDomainByScene(infoParam);
        if (infoOptional.isPresent()) {
            return infoOptional.get().getBaseUrl();
        }

        // 获取不到 备用地址的配置
        if (Objects.equals("AUTH_TAOBAO", param.getScene())) {
            return bizConfigProperties.getH5EnabledAuthTaoBaoServerHost();
        }

        // 暂时不处理scene 直接返回站外的h5服务根路径
        return bizConfigProperties.getH5EnabledOutsideServerHost();
    }
}
