/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.util;

import com.bxm.newidea.component.tools.StringUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTypeUtil {
    public static final Map<String, String> FILE_TYPE_MAP = new HashMap<String, String>();
    public static final String FILE_TYPE_GIF = "gif";
    public static final String FILE_TYPE_JPEG = "jpeg";
    public static final String FILE_TYPE_PNG = "png";
    public static final String FILE_TYPE_JPG = "jpg";
    public static final String FILE_TYPE_PDF = "pdf";
    public static final String FILE_TYPE_XLS = "xls";
    public static final String FILE_TYPE_XLSX = "xlsx";
    public static final String FILE_TYPE_DOC = "doc";
    public static final String FILE_TYPE_DOCX = "docx";
    private static final Logger LOG = LoggerFactory.getLogger(FileTypeUtil.class);

    private static void getAllFileType() {
        FILE_TYPE_MAP.put(FILE_TYPE_JPG, "FFD8FF");
        FILE_TYPE_MAP.put(FILE_TYPE_JPEG, "FFD8FF");
        FILE_TYPE_MAP.put(FILE_TYPE_PNG, "89504E47");
        FILE_TYPE_MAP.put(FILE_TYPE_GIF, "47494638");
        FILE_TYPE_MAP.put("tif", "49492A00");
        FILE_TYPE_MAP.put("bmp", "424D");
        FILE_TYPE_MAP.put("dwg", "41433130");
        FILE_TYPE_MAP.put("html", "68746D6C3E");
        FILE_TYPE_MAP.put("rtf", "7B5C727466");
        FILE_TYPE_MAP.put("xml", "3C3F786D6C");
        FILE_TYPE_MAP.put("rar", "52617221");
        FILE_TYPE_MAP.put("psd", "38425053");
        FILE_TYPE_MAP.put("eml", "44656C69766572792D646174653A");
        FILE_TYPE_MAP.put("dbx", "CFAD12FEC5FD746F");
        FILE_TYPE_MAP.put("pst", "2142444E");
        FILE_TYPE_MAP.put(FILE_TYPE_XLSX, "504B0304");
        FILE_TYPE_MAP.put(FILE_TYPE_XLS, "D0CF11E0");
        FILE_TYPE_MAP.put(FILE_TYPE_DOC, "D0CF11E0");
        FILE_TYPE_MAP.put(FILE_TYPE_PDF, "255044462D312E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileType(File file) {
        String filetype = null;
        FileInputStream is = null;
        byte[] b = new byte[50];
        try {
            is = new FileInputStream(file);
            ((InputStream)is).read(b);
            filetype = FileTypeUtil.getFileTypeByStream(b);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            LOG.error("FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                LOG.error("IO\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        return filetype;
    }

    public static final String getFileTypeByStream(byte[] b) {
        String filetypeHex = String.valueOf(FileTypeUtil.getFileHexString(b));
        for (Map.Entry<String, String> entry : FILE_TYPE_MAP.entrySet()) {
            String fileTypeHexValue = entry.getValue();
            if (!filetypeHex.toUpperCase().startsWith(fileTypeHexValue)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean checkFileType(File file) {
        String fileType = FileTypeUtil.getFileType(file);
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return false;
        }
        return FileTypeUtil.isImage(file, fileType);
    }

    public static boolean isImage(File file, String fileType) {
        return (FILE_TYPE_JPEG.equals(fileType) || FILE_TYPE_JPG.equals(fileType) || FILE_TYPE_PNG.equals(fileType) || FILE_TYPE_GIF.equals(fileType)) && FileTypeUtil.fileIsImage(file) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean fileIsImage(File file) {
        InputStream is = null;
        BufferedReader reader = null;
        FileReader fr = null;
        try {
            fr = new FileReader(file);
            is = new FileInputStream(file);
            BufferedImage image = ImageIO.read(is);
            if (image != null) {
                reader = new BufferedReader(fr);
                String exits = null;
                while ((exits = reader.readLine()) != null) {
                    if ((exits = FileTypeUtil.shiftD(exits)).indexOf("eval") <= -1 && exits.indexOf("<?php") <= -1) continue;
                    Boolean bl = false;
                    return bl;
                }
                Boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error("fileIsImage\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                LOG.error("fileIsImage IO\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        return false;
    }

    public static String shiftD(String str) {
        int size = str.length();
        char[] chs = str.toCharArray();
        for (int i = 0; i < size; ++i) {
            if (chs[i] > 'Z' || chs[i] < 'A') continue;
            chs[i] = (char)(chs[i] + 32);
        }
        return new String(chs);
    }

    public static boolean isPdf(String fileType) {
        return FILE_TYPE_PDF.equals(fileType);
    }

    public static boolean isExcel(String fileType) {
        return FILE_TYPE_XLSX.equals(fileType) || FILE_TYPE_XLS.equals(fileType);
    }

    public static boolean isWord(String fileType) {
        return FILE_TYPE_DOC.equals(fileType) || FILE_TYPE_DOCX.equals(fileType);
    }

    public static String getFileTypeStr(String fileType) {
        for (Map.Entry<String, String> entry : FILE_TYPE_MAP.entrySet()) {
            String fileTypeHexValue = entry.getValue();
            if (!fileType.equalsIgnoreCase(fileTypeHexValue)) continue;
            return entry.getKey();
        }
        return "";
    }

    public static final String getFileHexString(byte[] b) {
        StringBuilder stringBuilder = new StringBuilder();
        if (b == null || b.length <= 0) {
            return null;
        }
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        FileTypeUtil.getAllFileType();
    }
}

