package com.bxm.localnews.im.common.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis key值定义
 */
public class IMRedisKey {
    private IMRedisKey() {
    }

    /**
     * 用户即时通讯token值
     */
    public static KeyGenerator TOKEN = DefaultKeyGenerator.build("im", "cache", "token");

    /**
     * 消息存储集合，防止消息丢失，控制消费速度
     */
    public static KeyGenerator MSG_SET = DefaultKeyGenerator.build("im", "cache", "consumemsg");

    /**
     * 用户的未读消息数量，此值在localnews-msg服务中维护，此处仅用于判断用户发送消息的权限
     */
    public static KeyGenerator UN_READ_MSG = DefaultKeyGenerator.build("message", "unread");

    /**
     * 2.5.1 用户各种类型的最后一条未读消息
     * 此值在localnews-msg服务中维护
     */
    public static KeyGenerator LAST_MSG = DefaultKeyGenerator.build("message", "last");
}
