package com.bxm.localnews.im.enums;

/**
 * 融云 消息会话类型
 * 会话类型，二人会话是 PERSON 、讨论组会话是 PERSONS 、群组会话是 GROUP 、聊天室会话是 TEMPGROUP 、客服会话是 CUSTOMERSERVICE 、 系统通知是 NOTIFY 、应用公众服务是 MC 、公众服务是 MP。
 * 对应客户端 SDK 中 ConversationType 类型，二人会话是 1 、讨论组会话是 2 、群组会话是 3 、聊天室会话是 4 、客服会话是 5 、 系统通知是 6 、应用公众服务是 7 、公众服务是 8。
 */
public enum ChannelTypeEnum {

	PERSON(1,"PERSON"),
	PERSONS(2,"PERSONS"),
	GROUP(3,"GROUP"),
	TEMPGROUP(4,"TEMPGROUP"),
	CUSTOMERSERVICE(5,"CUSTOMERSERVICE"),
	NOTIFY(6,"NOTIFY"),
	MC(7,"MC"),
	MP(8,"MP");

	ChannelTypeEnum(Integer conversationType, String typeName){
		this.conversationType = conversationType;
		this.typeName = typeName;
	}

	private String typeName;

	private Integer conversationType;

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public Integer getConversationType() {
		return conversationType;
	}

	public void setConversationType(Integer conversationType) {
		this.conversationType = conversationType;
	}
}
