package com.bxm.localnews.im.facade;



import com.bxm.localnews.im.dto.PersonMessageDTO;
import com.bxm.localnews.im.facade.fallback.ForumPostFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-news", fallbackFactory = ForumPostFallbackFactory.class, primary = false)
public interface ForumPostFeignService {

	@GetMapping("/facade/forumPost/getForumPostByUserId")
	ResponseEntity<PersonMessageDTO.ForumPost> getForumpost(@RequestParam("userId") Long userId,@RequestParam("targetUserId") Long targetUserId);

}
