package com.bxm.localnews.im.facade;

import com.bxm.localnews.im.facade.fallback.MsgSupplyFallbackFactory;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-msg", fallbackFactory = MsgSupplyFallbackFactory.class, primary = false)
public interface MsgFeignService {

    @ApiOperation(value = "5-90-3 批量添加用户未读消息")
    @PostMapping("/facade/msg/batch/unread")
    void batchAddUnReadMsg(@RequestBody List<PushMessage> messages);

    @ApiOperation(value = "1-1-2 推送钉钉消息到即时通讯监控群")
    @ApiImplicitParam(name = "content", value = "推送内容")
    @PostMapping("/facade/message/dingtalk/im")
    void pushIMGroup(@RequestBody String content);

    @ApiOperation(value = "5-90-4 设置用户某类消息为已读状态")
    @PostMapping("/facade/msg/read")
    void setRead(@RequestParam("userId") Long userId, @RequestParam("msgType") String msgType);

    @ApiOperation(value = "5-90-5 添加用户的最后未读消息")
    @PostMapping("/facade/msg/batch/last")
    void batchAddLastMsg(@RequestBody List<PushMessage> messages);

    @ApiOperation(value = "5-94-1 添加用户事件，扩展信息中必须包含userId")
    @PostMapping("/facade/user/event/add")
    void add(@RequestBody PushPayloadInfo payloadInfo);
}
