package com.bxm.localnews.im.facade;

import com.bxm.localnews.im.dto.Note;
import com.bxm.localnews.im.facade.fallback.NoteFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-news", fallbackFactory = NoteFallbackFactory.class, primary = false)
public interface NoteFeignService {

    @GetMapping("/facade/note/getUserNoteList")
    ResponseEntity<List<Note>> getUserNoteList(@RequestParam("userId") Long userId);

}
