package com.bxm.localnews.im.facade;

import com.bxm.localnews.im.facade.fallback.QuartzManageFallbackFactory;
import com.bxm.localnews.im.param.ResetBlockParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "localnews-quartz", fallbackFactory = QuartzManageFallbackFactory.class, primary = false)
public interface QuartzManageService {

    @ApiOperation(value = "1-1-15 添加定时解除封禁(仅运行一次)")
    @PostMapping("/quartz/add/resetBlock")
    ResponseEntity<String> addResetBlock(@RequestBody ResetBlockParam param);
}
