package com.bxm.localnews.im.facade;

import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.im.vo.UserInfo;
import com.bxm.localnews.im.vo.VirtualUserInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class, primary = false)
public interface UserFeignService {

    @GetMapping(value = "/facade/user/info")
    ResponseEntity<UserBean> selectUserFromCache(@RequestParam("userId") Long userId);

    @ApiOperation(value = "9-93-15 判断用户是否关注了对方")
    @GetMapping("/facade/user/isFollow")
    ResponseEntity<Boolean> isFollow(@RequestParam("fromUserId") Long fromUserId, @RequestParam("toUserId") Long toUserId);

    @ApiOperation(value = "9-93-22 是否存在user关注了target的关注消息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "当前用户ID"),
            @ApiImplicitParam(name = "targetUid", value = "目标用户ID")
    })
    @GetMapping("/facade/user/hasFollowMsg")
    ResponseEntity<Boolean> hasFollowMsg(@RequestParam("userId") Long userId, @RequestParam("targetUid") Long targetUid);

    @PostMapping("/facade/user/batchUserInfo")
    ResponseEntity<List<UserInfo>> batchUserInfo(@RequestBody List<Long> userIds);

    /**
     * 获得虚拟用户
     * @param num
     * @return
     */
    @PostMapping("facade/user/getVirtualUserList")
    ResponseEntity<List<VirtualUserInfo>> getVirtualUserList(@RequestParam("num") Integer num);
}
