package com.bxm.localnews.im.facade.fallback;

import com.bxm.localnews.im.facade.BizClientConfigFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class BizClientConfigFeignServiceFactory implements FallbackFactory<BizClientConfigFeignService> {
    @Override
    public BizClientConfigFeignService create(Throwable throwable) {
        return  new BizClientConfigFeignService(){
            @Override
            public String getReplySayHello() {
                log.error(throwable.getMessage(), throwable);
                //默认的文案
                return "[\"欢迎欢迎，进群就是一家人了\",\"进群就不要想走了哦~\",\"欢迎欢迎，我们的大家庭又有新成员了\",\"萌新，快到碗里来\",\"萌新，快到碗里来\",\"来来来，老规矩，爆个照！\"]";
            }
        };
    }
}
