package com.bxm.localnews.im.facade.fallback;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.im.facade.BizLogFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/2/28 17:49
 * @desc
 */
@Component
@Slf4j
public class BizLogFallbackFactory implements FallbackFactory<BizLogFeignService> {
    @Override
    public BizLogFeignService create(Throwable throwable) {
        return new BizLogFeignService() {
            @Override
            public void point(PointReportParam param) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }
}

