package com.bxm.localnews.im.facade.fallback;

import com.bxm.localnews.im.dto.PersonMessageDTO;
import com.bxm.localnews.im.facade.ForumPostFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ForumPostFallbackFactory implements FallbackFactory<ForumPostFeignService> {
	@Override
	public ForumPostFeignService create(Throwable throwable) {
		return  new ForumPostFeignService() {

			@Override
			public ResponseEntity<PersonMessageDTO.ForumPost> getForumpost(Long userId, Long targetUserId) {
				log.error(throwable.getMessage(), throwable);
				return  ResponseEntity.badRequest().build();
			}
		};
	}
}
