package com.bxm.localnews.im.facade.fallback;

import com.bxm.localnews.im.facade.MsgFeignService;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
public class MsgSupplyFallbackFactory implements FallbackFactory<MsgFeignService> {

    @Override
    public MsgFeignService create(Throwable throwable) {
        return new MsgFeignService() {
            @Override
            public void batchAddUnReadMsg(List<PushMessage> messages) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void pushIMGroup(String content) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void setRead(Long userId, String msgType) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void batchAddLastMsg(List<PushMessage> messages) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void add(PushPayloadInfo payloadInfo) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }
}
