package com.bxm.localnews.im.facade.fallback;

import com.bxm.localnews.im.dto.Note;
import com.bxm.localnews.im.facade.NoteFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
public class NoteFallbackFactory implements FallbackFactory<NoteFeignService> {

    @Override
    public NoteFeignService create(Throwable throwable) {
        return new NoteFeignService() {

            @Override
            public ResponseEntity<List<Note>> getUserNoteList(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }
        };
    }

}
