package com.bxm.localnews.im.facade.fallback;

import com.bxm.localnews.im.facade.QuartzManageService;
import com.bxm.localnews.im.param.ResetBlockParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class QuartzManageFallbackFactory implements FallbackFactory<QuartzManageService> {
    @Override
    public QuartzManageService create(Throwable throwable) {
        return new QuartzManageService() {
            @Override
            public ResponseEntity<String> addResetBlock(ResetBlockParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body("");
            }
        };
    }
}
