package com.bxm.localnews.im.facade.fallback;

import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.facade.UserFeignService;
import com.bxm.localnews.im.vo.UserInfo;
import com.bxm.localnews.im.vo.VirtualUserInfo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
public class UserFallbackFactory implements FallbackFactory<UserFeignService> {

    @Override
    public UserFeignService create(Throwable throwable) {
        return new UserFeignService() {
            @Override
            public ResponseEntity<UserBean> selectUserFromCache(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<Boolean> isFollow(Long fromUserId, Long toUserId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> hasFollowMsg(Long userId, Long targetUid) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<List<UserInfo>> batchUserInfo(List<Long> userIds) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<List<VirtualUserInfo>> getVirtualUserList(Integer num) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
