package com.bxm.localnews.im.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.im.facade.BizClientConfigFeignService;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@AllArgsConstructor(onConstructor =@__(@Autowired))
public class ClientConfigIntegration {
    private final BizClientConfigFeignService bizClientConfigFeignService;

    public List<String> getReplySayHelloString (){
        String replySayHello = bizClientConfigFeignService.getReplySayHello();
        if (StringUtils.isNotBlank(replySayHello)){
            List<String> result = JSONObject.parseArray(replySayHello, String.class);
            return result;
        }
        return Lists.newArrayList();
    }

}
