package com.bxm.localnews.im.integration;

import com.bxm.localnews.im.dto.PersonMessageDTO;
import com.bxm.localnews.im.facade.ForumPostFeignService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@AllArgsConstructor(onConstructor =@__(@Autowired))
public class ForumpostIntegration {
	private final ForumPostFeignService forumPostFeignService;


	public PersonMessageDTO.ForumPost getRecentDevelopments(Long userId, Long targetUserId) {
		ResponseEntity<PersonMessageDTO.ForumPost> forumpost = forumPostFeignService.getForumpost(userId, targetUserId);
		return forumpost.getBody();
	}
}
