package com.bxm.localnews.im.integration;

import com.bxm.localnews.im.dto.LocationDTO;
import com.bxm.localnews.im.facade.LocationFeignService;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author zhaoyadong 2019/3/1 14:00
 * @desc
 */
@Service
public class LocationIntegrationService {

    private Map<String, LocationDTO> localCacheMap = Maps.newConcurrentMap();

    private long nextRefreshTime = 0L;

    private static final Long CACHE_MILLISECOND = 5 * 60 * 1000L;

    @Resource
    private LocationFeignService locationFeignService;

    public LocationDTO getLocationByGeocode(String code) {
        if (StringUtils.isBlank(code)) {
            return new LocationDTO();
        }

        //每五分钟重置一次本地缓存
        if (System.currentTimeMillis() > nextRefreshTime) {
            localCacheMap.clear();
            nextRefreshTime = System.currentTimeMillis() + CACHE_MILLISECOND;
        }

        //使用本地缓存
        LocationDTO location = localCacheMap.get(code);

        //本地缓存不存在时通过服务获取远程数据
        if (null == location) {
            location = locationFeignService.getLocationByGeocode(code).getBody();
            localCacheMap.put(code, location);
        }

        return location;
    }
}
