package com.bxm.localnews.im.integration;

import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.enums.ChannelTypeEnum;
import com.bxm.localnews.im.facade.MsgFeignService;
import com.bxm.localnews.im.vo.IMMessageBean;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service
public class MsgIntegrationService {

    private final MsgFeignService msgFeignService;

    private final UserIntegrationService userIntegrationService;

    @Autowired
    public MsgIntegrationService(MsgFeignService msgFeignService,
                                 UserIntegrationService userIntegrationService) {
        this.msgFeignService = msgFeignService;
        this.userIntegrationService = userIntegrationService;
    }

    /**
     * 给对应的用户增加未读消息
     * @param messages 即时消息记录
     */
    public void addUnreadMsg(List<IMMessageBean> messages) {
        if (null == messages) {
            return;
        }

        List<PushMessage> pushMessages = Lists.newArrayList();
        List<PushMessage> sendMessages = Lists.newArrayList();
        UserBean formUser;
        UserBean toUser;
        for (IMMessageBean message : messages) {
            if (StringUtils.equals(ChannelTypeEnum.PERSON.getTypeName(),message.getChannelType())){
                formUser = userIntegrationService.selectUserFromCache(message.getFromUserId());
                toUser = userIntegrationService.selectUserFromCache(message.getToUserId());
                if (Objects.nonNull(toUser) && Objects.nonNull(formUser)){
                    PushMessage pushMessage = PushMessage.build()
                            .setType(TemplateTypeEnum.TRANSMISSION)
                            .setPersistence(false)
                            .setTitle("你有一条新的消息")
                            .setContent(message.getBriefContent())
                            .setPushReceiveScope(PushReceiveScope.pushSignle(message.getToUserId()).setUserId(message.getToUserId()));

                    PushPayloadInfo payloadInfo = pushMessage.getPayloadInfo();
                    payloadInfo.setType(PushMessageEnum.IM_MESSAGE.getType());
                    payloadInfo.addExtend("nickname", formUser.getNickname());
                    payloadInfo.addExtend("headImg", formUser.getHeadImg());
                    payloadInfo.addExtend("customType", message.getFromUserId());

                    pushMessages.add(pushMessage);

                    //发送方增加未读消息
                    PushMessage sendMessage = PushMessage.build()
                            .setType(TemplateTypeEnum.TRANSMISSION)
                            .setPersistence(false)
                            .setTitle("")
                            .setContent(message.getBriefContent())
                            .setPushReceiveScope(PushReceiveScope.pushSignle(message.getToUserId()).setUserId(message.getFromUserId()));

                    PushPayloadInfo sendMsgPayloadInfo = sendMessage.getPayloadInfo();
                    sendMsgPayloadInfo.setType(PushMessageEnum.IM_MESSAGE.getType());
                    //发送方消息类型显示为接收方
                    sendMsgPayloadInfo.addExtend("nickname", toUser.getNickname());
                    sendMsgPayloadInfo.addExtend("headImg", toUser.getHeadImg());
                    sendMsgPayloadInfo.addExtend("customType", message.getToUserId());
                    sendMessages.add(sendMessage);
            }

            }
        }

        msgFeignService.batchAddUnReadMsg(pushMessages);
        msgFeignService.batchAddLastMsg(sendMessages);
    }

    public void pushIMGroup(String content) {
        msgFeignService.pushIMGroup(content);
    }

    public void setRead(Long userId, Long fromUserId) {
        msgFeignService.setRead(userId, String.valueOf(fromUserId));
    }

    /**
     * 添加用户解除封禁的事件
     * @param userId 解封的用户ID
     */
    public void addUnblockEvent(Long userId) {
        msgFeignService.add(PushPayloadInfo.build(PushMessageEnum.IM_UNBLOCK)
                .addExtend("userId", userId));
    }
}
