package com.bxm.localnews.im.integration;

import com.bxm.localnews.im.dto.Note;
import com.bxm.localnews.im.facade.NoteFeignService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@AllArgsConstructor(onConstructor = @__(@Autowired))
public class NoteIntegrationService {

    private final NoteFeignService noteFeignService;

    public List<Note> getUserNoteList(Long userId) {
        return noteFeignService.getUserNoteList(userId).getBody();
    }

}
