package com.bxm.localnews.im.integration;

import com.bxm.localnews.im.facade.QuartzManageService;
import com.bxm.localnews.im.param.ResetBlockParam;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

@Deprecated
@Service
@Slf4j
public class QuartzIntegrationService {
    @Resource
    private QuartzManageService quartzManageService;

    public void addResetBlock(Long userId, int mintues) {
        Date date = DateUtils.addField(new Date(), Calendar.MINUTE, mintues);
        //延迟30秒，防止第三方时间不一致
        date = DateUtils.addField(date, Calendar.SECOND, 30);

        log.debug("创建封禁用户的定时任务，用户ID:[{}]，封禁时长:[{}]，封禁时间:[{}]",
                userId,
                mintues,
                DateUtils.formatDateTime(date));

        ResetBlockParam param = new ResetBlockParam();
        param.setUnblockTime(date);
        param.setUserId(userId);

        quartzManageService.addResetBlock(param);
    }
}
