package com.bxm.localnews.im.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.facade.UserFeignService;
import com.bxm.localnews.im.vo.UserInfo;
import com.bxm.localnews.im.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service
@Slf4j
public class UserIntegrationService {

    private final UserFeignService userFeignService;

    private final RedisHashMapAdapter redisHashMapAdapter;

    private KeyGenerator userInfoKey = DefaultKeyGenerator.build("user", "cache", "userInfo");

    @Autowired
    public UserIntegrationService(UserFeignService userFeignService,
                                  RedisHashMapAdapter redisHashMapAdapter) {
        this.userFeignService = userFeignService;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    public UserBean selectUserFromCache(Long userId) {
        String cache = redisHashMapAdapter.get(userInfoKey, Objects.toString(userId), String.class);
        if (null != cache) {
            return JSON.parseObject(cache, UserBean.class);
        }

        ResponseEntity<UserBean> userBeanResponseEntity = this.userFeignService.selectUserFromCache(userId);
        if (null != userBeanResponseEntity && null != userBeanResponseEntity.getBody()) {
            return userBeanResponseEntity.getBody();
        }
        return null;
    }

    public Boolean isFollow(Long userId, Long targetUserId) {
        ResponseEntity<Boolean> response = userFeignService.isFollow(userId, targetUserId);
        if (response.hasBody()) {
            return response.getBody();
        }
        return false;
    }

    public Boolean hasFollowMsg(Long userId, Long targetUid) {
        ResponseEntity<Boolean> response = userFeignService.hasFollowMsg(userId, targetUid);
        if (response.hasBody()) {
            return response.getBody();
        }
        return false;
    }

    public List<UserInfo> batchUserInfo(List<Long> userIds) {
        ResponseEntity<List<UserInfo>> response = userFeignService.batchUserInfo(userIds);
        if (response.hasBody()) {
            return response.getBody();
        }
        return Lists.newArrayList();
    }

    public List<VirtualUserInfo> getVirtualUserList(Integer num) {
        ResponseEntity<List<VirtualUserInfo>> response = userFeignService.getVirtualUserList(num);
        if (response.hasBody()) {
            return response.getBody();
        }
        return Lists.newArrayList();
    }
}
