/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.integration;

import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.enums.ChannelTypeEnum;
import com.bxm.localnews.im.facade.MsgFeignService;
import com.bxm.localnews.im.integration.UserIntegrationService;
import com.bxm.localnews.im.vo.IMMessageBean;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgIntegrationService {
    private final MsgFeignService msgFeignService;
    private final UserIntegrationService userIntegrationService;

    @Autowired
    public MsgIntegrationService(MsgFeignService msgFeignService, UserIntegrationService userIntegrationService) {
        this.msgFeignService = msgFeignService;
        this.userIntegrationService = userIntegrationService;
    }

    public void addUnreadMsg(List<IMMessageBean> messages) {
        if (null == messages) {
            return;
        }
        ArrayList pushMessages = Lists.newArrayList();
        ArrayList sendMessages = Lists.newArrayList();
        for (IMMessageBean message : messages) {
            if (!StringUtils.equals((CharSequence)ChannelTypeEnum.PERSON.getTypeName(), (CharSequence)message.getChannelType())) continue;
            UserBean formUser = this.userIntegrationService.selectUserFromCache(message.getFromUserId());
            UserBean toUser = this.userIntegrationService.selectUserFromCache(message.getToUserId());
            if (!Objects.nonNull(toUser) || !Objects.nonNull(formUser)) continue;
            PushMessage pushMessage = PushMessage.build().setType(TemplateTypeEnum.TRANSMISSION).setPersistence(false).setTitle("\u4f60\u6709\u4e00\u6761\u65b0\u7684\u6d88\u606f").setContent(message.getBriefContent()).setPushReceiveScope(PushReceiveScope.pushSignle((Long)message.getToUserId()).setUserId(message.getToUserId()));
            PushPayloadInfo payloadInfo = pushMessage.getPayloadInfo();
            payloadInfo.setType(PushMessageEnum.IM_MESSAGE.getType());
            payloadInfo.addExtend("nickname", (Object)formUser.getNickname());
            payloadInfo.addExtend("headImg", (Object)formUser.getHeadImg());
            payloadInfo.addExtend("customType", (Object)message.getFromUserId());
            pushMessages.add(pushMessage);
            PushMessage sendMessage = PushMessage.build().setType(TemplateTypeEnum.TRANSMISSION).setPersistence(false).setTitle("").setContent(message.getBriefContent()).setPushReceiveScope(PushReceiveScope.pushSignle((Long)message.getToUserId()).setUserId(message.getFromUserId()));
            PushPayloadInfo sendMsgPayloadInfo = sendMessage.getPayloadInfo();
            sendMsgPayloadInfo.setType(PushMessageEnum.IM_MESSAGE.getType());
            sendMsgPayloadInfo.addExtend("nickname", (Object)toUser.getNickname());
            sendMsgPayloadInfo.addExtend("headImg", (Object)toUser.getHeadImg());
            sendMsgPayloadInfo.addExtend("customType", (Object)message.getToUserId());
            sendMessages.add(sendMessage);
        }
        this.msgFeignService.batchAddUnReadMsg(pushMessages);
        this.msgFeignService.batchAddLastMsg(sendMessages);
    }

    public void pushIMGroup(String content) {
        this.msgFeignService.pushIMGroup(content);
    }

    public void setRead(Long userId, Long fromUserId) {
        this.msgFeignService.setRead(userId, String.valueOf(fromUserId));
    }

    public void addUnblockEvent(Long userId) {
        this.msgFeignService.add(PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.IM_UNBLOCK).addExtend("userId", (Object)userId));
    }
}

