/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.facade.UserFeignService;
import com.bxm.localnews.im.vo.UserInfo;
import com.bxm.localnews.im.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UserIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(UserIntegrationService.class);
    private final UserFeignService userFeignService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private KeyGenerator userInfoKey = DefaultKeyGenerator.build((String)"user", (String)"cache", (String)"userInfo");

    @Autowired
    public UserIntegrationService(UserFeignService userFeignService, RedisHashMapAdapter redisHashMapAdapter) {
        this.userFeignService = userFeignService;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    public UserBean selectUserFromCache(Long userId) {
        String cache = (String)this.redisHashMapAdapter.get(this.userInfoKey, Objects.toString(userId), String.class);
        if (null != cache) {
            return (UserBean)JSON.parseObject((String)cache, UserBean.class);
        }
        ResponseEntity<UserBean> userBeanResponseEntity = this.userFeignService.selectUserFromCache(userId);
        if (null != userBeanResponseEntity && null != userBeanResponseEntity.getBody()) {
            return (UserBean)userBeanResponseEntity.getBody();
        }
        return null;
    }

    public Boolean isFollow(Long userId, Long targetUserId) {
        ResponseEntity<Boolean> response = this.userFeignService.isFollow(userId, targetUserId);
        if (response.hasBody()) {
            return (Boolean)response.getBody();
        }
        return false;
    }

    public Boolean hasFollowMsg(Long userId, Long targetUid) {
        ResponseEntity<Boolean> response = this.userFeignService.hasFollowMsg(userId, targetUid);
        if (response.hasBody()) {
            return (Boolean)response.getBody();
        }
        return false;
    }

    public List<UserInfo> batchUserInfo(List<Long> userIds) {
        ResponseEntity<List<UserInfo>> response = this.userFeignService.batchUserInfo(userIds);
        if (response.hasBody()) {
            return (List)response.getBody();
        }
        return Lists.newArrayList();
    }

    public List<VirtualUserInfo> getVirtualUserList(Integer num) {
        ResponseEntity<List<VirtualUserInfo>> response = this.userFeignService.getVirtualUserList(num);
        if (response.hasBody()) {
            return (List)response.getBody();
        }
        return Lists.newArrayList();
    }
}

