package com.bxm.localnews.im.dto;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户会话信息")
@Data
public class SessionInfoDto extends BasicParam {

    @ApiModelProperty("聊天对象是否关注了当前用户，true表示已关注")
    private Boolean follow;

    @ApiModelProperty("是否允许发送消息给对应的用户,false表示无法给对方发送消息")
    private Boolean allowSend;

    @ApiModelProperty("拒收消息的文案，当allowSend为false时，根据需求呈现给用户")
    private String rejectMsg;
}
