package com.bxm.localnews.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "删除消息的参数")
@Data
public class ClearMessageParam {

    @ApiModelProperty("当前用户ID")
    private Long userId;

    @ApiModelProperty("删除会话的用户ID")
    private Long sessionUserId;

    @ApiModelProperty("用户点击删除的时间戳，将该时间点之前的聊天记录设置为删除状态")
    private Date clearPoint;
}
