package com.bxm.localnews.im.vo;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

@Data
@Builder
public class IMMessageBean {

    @Tolerate
    public IMMessageBean() {

    }

    /**
     * 消息ID，采用第三方ID
     */
    private String msgId;

    /**
     * 发送消息的用户ID
     */
    private Long fromUserId;

    /**
     * 接收消息的用户ID
     */
    private Long toUserId;

    /**
     * 消息类型
     */
    private String msgType;

    /**
     * 原始消息内容
     */
    private String content;

    /**
     * 缩略消息
     */
    private String briefContent;

    /**
     * 解析后的消息
     */
    private String parseContent;

    /**
     * 消息渠道类型
     */
    private String channelType;

    /**
     * 消息实际发送时间
     */
    private Date msgTimestamp;

    /**
     * 敏感词类型
     */
    private Integer sensitiveType;

    /**
     * 消息发送来源
     */
    private String source;

    /**
     * 群组消息指定特殊用户ID
     */
    private String groupUserIds;
}
