package com.bxm.localnews.facade;

import java.math.BigDecimal;

import com.bxm.localnews.facade.fallback.AccountFallbackFactory;
import com.bxm.localnews.param.DeductPointParam;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author zhaoyadong 2019/3/15 10:47
 * @desc
 */
@FeignClient(value = "localnews-user", fallbackFactory = AccountFallbackFactory.class)
public interface AccountFeignService {


    @PostMapping("/facade/account/balance/deduct")
    ResponseEntity<Boolean> deductUserBalance(DeductPointParam deductPointParam);

    @PostMapping("/facade/account/balance/confirm")
    ResponseEntity<Boolean> deductConfirmUserBalance(DeductPointParam deductPointParam);

    @PostMapping("/facade/account/balance/add")
    void addUserBalance(DeductPointParam deductPointParam);

    @GetMapping("/facade/account/balance")
    ResponseEntity<BigDecimal> selectGoldBalanceByUserId(Long userId);
}
