package com.bxm.localnews.facade;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.vo.Message;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/3/2 10:38
 * @desc
 */
@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class)
public interface UserFeignService {

    @GetMapping("/facade/user/info")
    ResponseEntity<UserInfoDTO> getUserFromCache(@RequestParam("userId") Long userId);

    @GetMapping("/facade/user/headimg")
    ResponseEntity<String> getDefaultHeadImgUrl();

    @GetMapping("/facade/user/detail")
    ResponseEntity<User> selectByPrimaryKey(@RequestParam("userId") Long userId);

    @PostMapping("/facade/user/unionId")
    ResponseEntity<Boolean> checkUnionIdIsUser(@RequestParam("unionId") String unionId);

    @PostMapping("/facade/user/create")
    ResponseEntity<Message> createUser(@RequestBody UserParam userParam);

    @GetMapping("/facade/user/temp")
    ResponseEntity<Boolean> isTempUser(@RequestParam("userId") Long userId);

    @GetMapping("/facade/user/risk")
    ResponseEntity<Boolean> isRiskUser(@RequestParam("userId") Long userId);
}
