package com.bxm.localnews.facade.fallback;

import com.bxm.localnews.facade.UserAuthFeignService;
import com.bxm.localnews.vo.UserAuth;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/2 11:05
 * @desc
 */
@Component
@Slf4j
public class UserAuthFallbackFactory implements FallbackFactory<UserAuthFeignService> {

    @Override
    public UserAuthFeignService create(Throwable throwable) {
        return new UserAuthFeignService() {
            @Override
            public ResponseEntity<UserAuth> selectUserAuthByOpenId(String openId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new UserAuth());
            }

            @Override
            public ResponseEntity<UserAuth> selectUserAuthByUnionId(String unionId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new UserAuth());
            }

            @Override
            public ResponseEntity<UserAuth> selectAppletUserAuthByUserId(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new UserAuth());
            }

            @Override
            public ResponseEntity<UserAuth> selectUserAuthByAppOpenId(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new UserAuth());
            }

            @Override
            public ResponseEntity<UserAuth> selectAppletUserAuthByOpenId(String openId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new UserAuth());
            }
        };
    }
}
