package com.bxm.localnews.integration;

import com.bxm.localnews.facade.UserAuthFeignService;
import com.bxm.localnews.vo.UserAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/2 11:03
 * @desc
 */
@Service
public class UserAuthIntegrationService {

    @Autowired
    private UserAuthFeignService userAuthFeignService;

    public UserAuth selectUserAuthByOpenId(String openId) {
        return userAuthFeignService.selectUserAuthByOpenId(openId).getBody();
    }

    public UserAuth selectUserAuthByUnionId(String unionId) {
        return userAuthFeignService.selectUserAuthByUnionId(unionId).getBody();
    }

    public UserAuth selectUserAuthByUserId(Long userId) {
        return userAuthFeignService.selectUserAuthByAppOpenId(userId).getBody();
    }

    public UserAuth selectAppletUserAuthByUserId(Long userId) {
        return userAuthFeignService.selectAppletUserAuthByUserId(userId).getBody();
    }

    public UserAuth selectAppletUserAuthByOpenId(String openId) {
        return userAuthFeignService.selectAppletUserAuthByOpenId(openId).getBody();
    }

}
