package com.bxm.localnews.integration;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.vo.Message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/2 10:30
 * @desc
 */
@Service
public class UserIntegrationService {

    @Autowired
    private UserFeignService userFeignService;

    public UserInfoDTO getUserFromRedisDB(Long userId) {
        return userFeignService.getUserFromCache(userId).getBody();
    }

    public String getDefaultHeadImgUrl() {
        return userFeignService.getDefaultHeadImgUrl().getBody();
    }

    public User selectByPrimaryKey(Long userId) {
        return userFeignService.selectByPrimaryKey(userId).getBody();
    }

    public Boolean checkUnionIdIsUser(String unionId) {
        return userFeignService.checkUnionIdIsUser(unionId).getBody();
    }

    public Message createUser(UserParam userParam) {
        return userFeignService.createUser(userParam).getBody();
    }

    public Boolean isTempUser(Long userId) {
        return userFeignService.isTempUser(userId).getBody();
    }

    public Boolean isRiskUser(Long userId) {
        return userFeignService.isRiskUser(userId).getBody();
    }
}
