package com.bxm.localnews.vo;

import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "用户账户信息")
public class UserAmount {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("状态")
    private Byte state;

    @ApiModelProperty("金币余额")
    private BigDecimal jbBalance;

    @ApiModelProperty("累计金币额")
    private BigDecimal totalJbBalance;

    @ApiModelProperty("零钱余额")
    private BigDecimal rmbBalance;

    @ApiModelProperty("累计零钱收益")
    private BigDecimal totalRmbBalance;

    @ApiModelProperty("更新时间")
    private Date udpateTime;

    public UserAmount() {

    }

    //初始用户资金账户
    public UserAmount(Long userId) {
        this.userId = userId;
        this.state = 10;
        BigDecimal bd = new BigDecimal(0);
        this.jbBalance = bd;
        this.totalJbBalance = bd;
        this.rmbBalance = bd;
        this.totalRmbBalance = bd;
    }

    public void addBalanceForJb(BigDecimal jbBalance) {
        this.jbBalance = this.getJbBalance().add(jbBalance);
        this.totalJbBalance = this.getTotalJbBalance().add(jbBalance);
    }

    public void addBalanceForRmb(BigDecimal rmbBalance) {
        this.rmbBalance = this.getRmbBalance().add(rmbBalance);
        this.totalRmbBalance = this.getTotalRmbBalance().add(rmbBalance);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Byte getState() {
        return this.state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public BigDecimal getJbBalance() {
        return this.jbBalance;
    }

    public void setJbBalance(BigDecimal jbBalance) {
        this.jbBalance = jbBalance;
    }

    public BigDecimal getTotalJbBalance() {
        return this.totalJbBalance;
    }

    public void setTotalJbBalance(BigDecimal totalJbBalance) {
        this.totalJbBalance = totalJbBalance;
    }

    public BigDecimal getRmbBalance() {
        return this.rmbBalance;
    }

    public void setRmbBalance(BigDecimal rmbBalance) {
        this.rmbBalance = rmbBalance;
    }

    public BigDecimal getTotalRmbBalance() {
        return this.totalRmbBalance;
    }

    public void setTotalRmbBalance(BigDecimal totalRmbBalance) {
        this.totalRmbBalance = totalRmbBalance;
    }

    public Date getUdpateTime() {
        return this.udpateTime;
    }

    public void setUdpateTime(Date udpateTime) {
        this.udpateTime = udpateTime;
    }

}