package com.bxm.localnews.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Created by Administrator on 2018/2/23.
 * 用户信息
 */
@ApiModel(description = "用户实体返回包装类")
@Data
public class UserInfoDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("性别 0:未知; 1:男; 2:女")
    private Byte sex;

    @ApiModelProperty("用户访问凭证")
    private String token;

    @ApiModelProperty("状态")
    private Byte state;

    @ApiModelProperty("微信")
    private String weixin;

    @ApiModelProperty("手机")
    private String phone;

    @ApiModelProperty("注册来源")
    private String registerChannel;

    @ApiModelProperty(value = "注册关联id")
    private Long relationId;

    @ApiModelProperty(value = "邀请人id")
    private Long inviteUserId;

    @ApiModelProperty(value = "家乡地区编码")
    private String hometownCode;

    @ApiModelProperty(value = "家乡名称")
    private String hometownName;

    @ApiModelProperty("用户资料完善情况")
    private Long infoCompleteState;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty("点赞数")
    private Integer likeNum;
}
