package com.bxm.localnews.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

@ApiModel(description = "首页投票辅助信息")
@Data
@Builder
public class VoteHomeDTO {

    @Tolerate
    public VoteHomeDTO() {
    }

    @ApiModelProperty("内容ID，可能为新闻或帖子")
    private Long id;

    @ApiModelProperty("内容标题")
    private String title;

    @ApiModelProperty("内容封面图")
    private String coverImg;

    @ApiModelProperty("内容类型，FORUM:帖子，NEWS：新闻")
    private String type;

    @ApiModelProperty("是否存在投票插件，true表示存在")
    private Boolean hasVote;
}
