package com.bxm.localnews.facade;

import com.bxm.localnews.facade.fallback.CommodityInfoFallbackFactory;
import com.bxm.newidea.component.vo.ResponseJson;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "fossicker-commodity", fallbackFactory = CommodityInfoFallbackFactory.class, primary = false)
public interface CommodityInfoFeignService {


    /**
     * 4-53-04 获取淘宝联盟跳转地址
     * @return 跳转链接
     */
    @GetMapping("facade/commodity/info/getTaoBaoUnion")
    ResponseJson<String> getTaoBaoUnionStr(@RequestParam("adzoneId") Long adzoneId,
                                @RequestParam("relationId") String relationId,
                                @RequestParam("promotionSceneId") Long promotionSceneId,
                                           @RequestParam("appName") String appName);
    /**
     * 4-53-05 创建淘口令
     * @param url 跳转的url地址
     * @param logUrl 图标地址
     * @param text 显示文案
     * @return 生成的淘口令
     */
    @GetMapping("facade/commodity/info/createTaoWord")
    ResponseJson<String> createTaoWord(@RequestParam("url") String url,
                                       @RequestParam("logUrl") String logUrl,
                                       @RequestParam("text") String text);
}
